/*
	File:		LayoutPane.cp

	Contains:	Class to drive our layout pane, demonstrating group boxes.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <2>	10/28/97	edv		Use RadioGroup control!
		 <1>	 9/11/97	edv		First checked in.
*/

#include "LayoutPane.h"
#include "Appearance.h"
#include "AppearanceHelpers.h"
#include "UDialogUtils.h"

enum
{
	kPrimaryGroup		= 1,
	kUserPane			= 2,
	kSecondaryGroup		= 3,
	kSeparator			= 4,
	kRadioGroup			= 5,
	kLevel1Radio		= 6,
	kLevel2Radio		= 7,
	kLevel3Radio		= 8,
	kUseMilliCheck		= 9,
	kFullCheck			= 10
};

LayoutPane::LayoutPane( DialogPtr dialog, SInt16 items ) : MegaPane( dialog, items )
{
	ControlHandle	control;
	
	AppendDialogItemList( dialog, 6005, overlayDITL );
	
	UDialogUtils::SetDialogItemValue( dialog, fOrigItems + kPrimaryGroup, 1 );
	
	GetDialogItemAsControl( dialog, fOrigItems + kLevel1Radio, &control );
	SetControlMaximum( control, 2 );
	GetDialogItemAsControl( dialog, fOrigItems + kLevel2Radio, &control );
	SetControlMaximum( control, 2 );
	GetDialogItemAsControl( dialog, fOrigItems + kLevel3Radio, &control );
	SetControlMaximum( control, 2 );
	UDialogUtils::SetDialogItemValue( dialog, fOrigItems + kRadioGroup, 2 );
	UDialogUtils::SetDialogItemValue( dialog, fOrigItems + kLevel3Radio, 1 );
	UDialogUtils::SetDialogItemValue( dialog, fOrigItems + kLevel1Radio, 2 );
	UDialogUtils::SetDialogItemValue( dialog, fOrigItems + kLevel1Radio, 0 );
	UDialogUtils::SetDialogItemValue( dialog, fOrigItems + kLevel2Radio, 1 );
}

LayoutPane::~LayoutPane()
{
	ShortenDITL( fDialog, CountDITL( fDialog ) - fOrigItems );
}

void
LayoutPane::ItemHit( SInt16 item )
{
	SInt16			localItem;
	ControlHandle	control;
	
	localItem = item - fOrigItems;
	
	switch( localItem )
	{
		case kPrimaryGroup:
			UDialogUtils::ToggleCheckBox( fDialog, item );
			GetDialogItemAsControl( fDialog, fOrigItems + kUserPane, &control );
			if ( UDialogUtils::GetDialogItemValue( fDialog, item ) == 1 )
				ActivateControl( control );
			else
				DeactivateControl( control );
			break;
		
		case kUseMilliCheck:
		case kFullCheck:
			UDialogUtils::ToggleCheckBox( fDialog, item );
			break;
			
	}
}
